<?php
use Tygh\Registry;

if (!defined('BOOTSTRAP')) { die('Access denied'); }

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Ваш существующий код для обработки POST-запросов
    if ($mode == 'update') {
        $storefront_id = isset($_REQUEST['storefront_id']) ? (int) $_REQUEST['storefront_id'] : 1;
        $content = isset($_REQUEST['llms_data']['content']) ? $_REQUEST['llms_data']['content'] : '';

        $exists = db_get_field("SELECT llms_id FROM ?:ip5_llms_data WHERE storefront_id = ?i", $storefront_id);

        if ($exists) {
            db_query("UPDATE ?:ip5_llms_data SET data = ?s WHERE storefront_id = ?i", $content, $storefront_id);
        } else {
            db_query("INSERT INTO ?:ip5_llms_data (storefront_id, data) VALUES (?i, ?s)", $storefront_id, $content);
        }

        // Записываем файл в корень
        $root_dir = rtrim(DIR_ROOT, '/'); // Константа DIR_ROOT в CS-Cart указывает на корень
        $file_path = $root_dir . '/llms.txt';

        if (file_put_contents($file_path, $content) !== false) {
            //fn_set_notification('N', __('notice'), __('text_changes_saved') . ' И файл llms.txt обновлён.');
        } else {
            fn_set_notification('E', __('error'), 'Не удалось записать файл llms.txt');
        }
    }

    return [CONTROLLER_STATUS_OK, 'ip5_seo_llms.manage'];
}

if ($mode == 'manage') {
    $storefront_id = isset($_REQUEST['storefront_id']) ? (int) $_REQUEST['storefront_id'] : 1;
    $robots_data = db_get_field("SELECT data FROM ?:ip5_llms_data WHERE storefront_id = ?i", $storefront_id);

    Tygh::$app['view']->assign([
        'llms' => $robots_data,
        'ftp_access' => []
    ]);
} 